`timescale 1ns / 1ps
//////////////////////////////////////////////////////////////////////////////////
// Company: 
// Engineer: 
// 
// Create Date: 12/11/2023 09:54:43 PM
// Design Name: 
// Module Name: control_unit
// Project Name: 
// Target Devices: 
// Tool Versions: 
// Description: 
// 
// Dependencies: 
// 
// Revision:
// Revision 0.01 - File Created
// Additional Comments:
// 
//////////////////////////////////////////////////////////////////////////////////


module MARIE(
        clk,
        rst_n,
        T,
        disp_ir,
        disp_outReg,
        disp_inReg,
        disp_ac,
        disp_mbr,
        disp_pc,
        disp_mar,
        disp_ram_data
    );
    
    parameter test_scenario = 0;
    parameter addr_width = 12;
    parameter word_width = 16;
    parameter flag_width = 2;
    
    `define _we P[5:3]
    `define _oe P[2:0]
    
    input            clk;
    input            rst_n;
    output [7:0]     T;
    output [word_width-1 : 0]    disp_ir; 
    output [word_width-1 : 0]    disp_outReg; 
    output [word_width-1 : 0]    disp_inReg; 
    output [word_width-1 : 0]    disp_ac; 
    output [word_width-1 : 0]    disp_mbr; 
    output [addr_width-1 : 0]    disp_pc; 
    output [addr_width-1 : 0]    disp_mar; 
    output [word_width-1 : 0]    disp_ram_data;

    // instantiate command unit
    wire [5:0]         P;
    wire [2:0]         A;
    wire               LaltAC;
    wire               LaltMBR;
    control_unit #(word_width) uc(clk, rst_n, disp_ir, flags_out, P, A, LaltAC, LaltMBR, T);
    
    //[1] instantiate MAR register and related connections
    wire[addr_width-1 : 0]      mar_in;
    wire[addr_width-1 : 0]      mar_out;
    register #(addr_width) mar(clk, rst_n, `_oe == 3'd1, `_we == 1, mar_in, mar_out, disp_mar); 
    
   //[2] instantiate PC register and related connections
    wire[addr_width-1 : 0]      pc_in;
    wire[addr_width-1 : 0]      pc_out;
    enchanted_counter #(addr_width) pc(clk, rst_n, `_oe == 3'd2, `_we == 2, A[2] ,pc_in, pc_out, disp_pc); 
   
   //[3] instantiate MBR register and related connections
    wire[word_width-1 : 0]      mbr_in;
    wire[word_width-1 : 0]      mbr_out;
    register #(word_width) mbr(clk, rst_n, `_oe == 3'd3, `_we == 3, LaltMBR ? disp_ac : mbr_in, mbr_out, disp_mbr);
     
   //[4] instantiate AC register and related connections
    wire[word_width-1 : 0]      ac_in;
    wire[word_width-1 : 0]      ac_out;
    register #(word_width) ac(clk, rst_n, `_oe == 3'd4, `_we == 4, LaltAC ? alu_out : ac_in, ac_out, disp_ac);
   
    //[5] instantiate MAR register and related connections
    wire[word_width-1 : 0]      inReg_in;
    wire[word_width-1 : 0]      inReg_out;
    register #(word_width) inReg(clk, rst_n, `_oe == 3'd5, `_we == 5, inReg_in, inReg_out, disp_inReg);
    
    //[6] instantiate MAR register and related connections
    wire[word_width-1 : 0]      outReg_in;
    wire[word_width-1 : 0]      outReg_out;
    register #(word_width) outReg(clk, rst_n, `_oe == 3'd6, `_we == 6, outReg_in, outReg_out, disp_outReg);
    
   //[7] instantiate IR register and related connections
    wire[word_width-1 : 0]      ir_in;
    wire[word_width-1 : 0]      ir_out;
    register #(word_width) ir(clk, rst_n, `_oe == 3'd7, `_we == 7, ir_in, ir_out, disp_ir);
     
    // instantiate ALU and related connections
    wire[word_width-1 : 0]      alu_out;
    wire[flag_width-1 : 0]      flags_out;
    alu #(word_width,flag_width) alu(disp_ac, disp_mbr, A[1:0], alu_out, flags_out);
    
    // instantiate RAM memory and related connections
    wire[word_width-1 : 0]      ram_in;
    wire[word_width-1 : 0]      ram_out;
    ram #(.test_scenario(test_scenario), .width(word_width)) RAM (clk, `_oe === 0 & `_we !==0, `_oe !== 0 & `_we === 0, disp_mar, ram_in, ram_out, disp_ram_data);
    
    // instatiate the bus that connects everything toghether
    bus #(word_width) mag(ir_out, ir_in, inReg_out, inReg_in, outReg_out, outReg_in, ac_out, ac_in, mbr_out, mbr_in, {4'b0, pc_out}, pc_in,{4'b0, mar_out}, mar_in, ram_out, ram_in);
    
    
endmodule